<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Admin;
use Validator;
use Auth;

class AdminsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index() {
    
		$admins = Admin::all(); 
		
    	return view('admins/index',['admins'=>$admins]);
		
    }
	
	public function create() {
    	
    	return view('admins/create');
		
    }
	 
	public function store(Request $request){
		$request->validate([
            'name' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-8])(?=.*?[#?!@$%^&*-]).{6,}$/',
       ],[
        	'name.required'=>"Admin User Name is required",
        	'email.required'=>"Email is required",
        	'email.unique'=>"Email already in use",
        	'password.required' => 'Login Password is required',
            'password.regex' => 'Password must be more than 8 characters long, should contain at-least 1 Uppercase, 1 Lowercase, 1 Numeric and 1 special character',
            
        ]);
		
		
		$user = new Admin;
		$user->name 	= $request->name;
		$user->phone 	= $request->phone;
		$user->email 	= $request->email;
		$user->password = Hash::make($request->password);
		$user->address 	= $request->address;
		
		
	
		try{
			$user->save();
			return redirect()->back()->with('success',"Admin User created successfully.");
		} catch(Exception $e){
			return redirect()->back()->withInput()->with('danger',"Admin User has not been created.");
		}
		
		
	} 

	public function edit($id) {
    	$admin = Admin::find($id);
		if(is_null($admin)){
			return redirect()->route('admins.index')->with('warning',"Admin User does not exist.");
		}
    	return view('admins/edit',['user'=>$admin]);
	}
	
	public function update(Request $request,$id){
		if(empty($request->password)){
			$request->validate([
	            'name' => 'required',
	            'email' => 'required|unique:users,email,'.$id.',id,deleted_at,NULL',
	       ],[
	        	'name.required'=>"Admin User Name is required",
	        	'email.required'=>"Email is required",
	        	'email.unique'=>"Email already in use",
	        ]);
		} else {
			$request->validate([
	            'name' => 'required',
	            'email' => 'required|unique:users,email,'.$id.',id,deleted_at,NULL',
	            'password' => 'regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-8])(?=.*?[#?!@$%^&*-]).{6,}$/',
	       ],[
	        	'name.required'=>"Admin User Name is required",
	        	'email.required'=>"Email is required",
	        	'email.unique'=>"Email already in use",
	        	'password.regex' => 'Password must be more than 8 characters long, should contain at-least 1 Uppercase, 1 Lowercase, 1 Numeric and 1 special character',
	        ]);
		}
		
		
		
		$user = Admin::find($id);
		$user->name 	= $request->name;
		$user->phone 	= $request->phone;
		$user->email 	= $request->email;
		if(!empty($request->password)){
			$user->password = Hash::make($request->password);
		} 
		$user->address 	= $request->address;
		$user->enabled = $request->enabled;
		
		try{
			$user->save();
			return redirect()->back()->with('success',"Admin User updaed successfully.");
		} catch(Exception $e){
			return redirect()->back()->withInput()->with('danger',"Admin User has not been updated.");
		}
		
		
	} 


	public function destroy(Request $request,$id){
		//this will soft delete the product
		
		if(Admin::destroy($id)){
			return redirect()->back()->with('success','Admin has been Deleted!');
		} else {
			return redirect()->back()->with('error','Admin has not been Deleted!');
		}
		
		
	}
	 
	 
	 
	 
}
